# Re{code} Front HTML Editor

> WordPress plugin — Frontend HTML editor powered by CodeMirror.

[![WordPress Plugin Version](https://img.shields.io/badge/version-3.5.0-blue)](https://wordpress.org/plugins/recode-front-html-editor/)
[![License: GPL v2](https://img.shields.io/badge/License-GPLv2-blue.svg)](https://www.gnu.org/licenses/gpl-2.0.html)
[![Requires WP](https://img.shields.io/badge/WordPress-5.9%2B-blue)](https://wordpress.org/)
[![Requires PHP](https://img.shields.io/badge/PHP-7.4%2B-purple)](https://www.php.net/)

Edit `post_content` directly on the frontend of your WordPress site — with a full CodeMirror editor, format toolbar, custom snippets, keyboard shortcuts, and live preview. No page reload. No backend switching.

---

## Features

- **Live on-page editing** — click Edit, change HTML, hit Save → page updates in place
- **CodeMirror 5** — HTML/CSS/JS syntax highlighting, auto-close tags, bracket matching
- **Format toolbar** — Bold, Italic, Strike, Highlight, Code, H2, H3, P, Blockquote, UL, OL, Link, Image
- **Custom Snippets** — save any HTML block as a toolbar button; use `{|}` to mark cursor position after insert
- **Keyboard shortcuts** — `Ctrl+E` (open/close), `Ctrl+S` (save), `Escape` (cancel), `Ctrl+B/I/K`
- **Element Picker** — click any DOM element to get its CSS selector with ancestor breadcrumb navigation
- **Dark & Light themes** — Dracula / Eclipse, configurable in Settings
- **Configurable selector** — choose from theme presets or enter any custom CSS selector
- **Secure** — nonce, per-post `edit_post` capability check, `wp_kses_post` sanitization

---

## Installation

```bash
# Via WP-CLI
wp plugin install recode-front-html-editor --activate

# Or manually
cd /path/to/wp-content/plugins
git clone https://github.com/recodecommerce/recode-front-html-editor.git
```

Then go to **Settings → Front HTML Editor** and configure the content selector for your theme.

---

## Custom Snippets

Go to **Settings → Front HTML Editor → Custom Snippets** to add reusable HTML blocks.
Each snippet gets its own button in the editor toolbar (highlighted in amber to distinguish from standard buttons).

Use `{|}` in the code to mark where the cursor should land after inserting:

```html
<div class="see-also-block">
  <div class="see-also-title">See also:</div>
  <ul>
    <li><a href="{|}"></a></li>
  </ul>
</div>
```

---

## Repository Structure

```
recode-front-html-editor/
├── recode-front-html-editor.php   # Main plugin file
├── uninstall.php                  # Clean removal
├── readme.txt                     # WordPress.org readme
├── README.md                      # This file
├── index.php                      # Directory listing protection
├── assets/
│   ├── editor.js                  # Frontend JS (jQuery + CodeMirror)
│   ├── editor.css                 # Frontend CSS
│   └── index.php
└── languages/
    └── index.php
```

---

## SVN / WordPress.org Deployment

```bash
# First time: check out the SVN repository
svn co https://plugins.svn.wordpress.org/recode-front-html-editor svn

# Copy src to trunk
xcopy /E /Y src\* svn\trunk\

# Create tag
xcopy /E /Y svn\trunk\* svn\tags\3.5.0\

# Commit
cd svn
svn add --force .
svn ci -m "Release 3.5.0"
```

---

## Security

| Check | Implementation |
|-------|---------------|
| AJAX nonce | `check_ajax_referer('rfhe_nonce', 'nonce')` |
| Per-post capability | `current_user_can('edit_post', $post_id)` |
| Content sanitization | `wp_kses_post()` |
| Output escaping | `esc_html()`, `esc_attr()`, `esc_url()` |
| Snippet sanitization | label: `sanitize_text_field()`, code: `wp_kses_post()` |
| Visibility | Toolbar only rendered for users with edit rights |

---

## Changelog

### 3.5.1
- **Fixed:** removed load_plugin_textdomain() — WordPress 4.6+ loads translations automatically
- **Fixed:** escaped output in field_editor_theme() to satisfy Plugin Check requirements
- **Updated:** Tested up to WordPress 6.9

### 3.5.0
- **Added:** Custom Snippets — add any HTML block as a toolbar button via Settings
- **Added:** `{|}` cursor marker — controls where the cursor lands after snippet insert
- **Added:** Snippet Tips card in Settings sidebar
- **Added:** Distinct amber color for snippet buttons in the editor toolbar
- **Changed:** Format toolbar HTML built dynamically to support variable number of snippets

### 3.4.3
- **Changed:** Internal prefix renamed from `rfie` to `rfhe` everywhere
- **Changed:** Plugin URI and Author URI point to dedicated plugin page
- **Added:** Footer block on Settings page (Plugin Page / GitHub / Contact)

### 3.4.2
- **Security:** `ajax_get_content` now checks `edit_post($post_id)` per-post
- **Fix:** Body padding-top scoped to `body.rfhe-active` only
- **Fix:** Pick button colors respect dark/light theme
- **Added:** `load_plugin_textdomain()`, `uninstall.php`, `index.php` security files

### 3.4.0
- Element Picker with ancestor breadcrumb navigation
- Format toolbar and keyboard shortcuts
- Dark/light theme support and configurable content selector

---

## License

GPL v2 or later — https://www.gnu.org/licenses/gpl-2.0.html

© [re{code}commerce](https://recodecommerce.com/wordpress-plugins/recode-front-html-editor)
